<?php

declare(strict_types=1);

namespace Erlage\Photogram\Tools\Fso\Disk;

use Erlage\Photogram\Settings;
use MicrosoftAzure\Storage\Blob\BlobRestProxy;
use Erlage\Photogram\Constants\ServerConstants;

class DiskAzureBlob implements InterfaceDisk
{
    /**
     * @var string
     */
    private $container;

    /**
     * @var BlobRestProxy
     */
    private $client;

    public function __construct()
    {
        $connectionString = Settings::getString(ServerConstants::SS_TEXT_AZURE_BLOB_DSN);

        $this -> client = BlobRestProxy::createBlobService($connectionString);

        $this -> container = Settings::getString(ServerConstants::SS_TEXT_AZURE_BLOB_CONTAINER);
    }

    public function write(string $objectId, string $contents): void
    {
        $this -> client -> createBlockBlob(
            $this -> container,
            $objectId,
            $contents
        );
    }

    public function read(string $objectId): string
    {
        $blob = $this -> client -> getBlob($this -> container, $objectId);

        \ob_start();

        \fpassthru($blob -> getContentStream());

        return \ob_get_clean();
    }

    public function delete(string $objectId): void
    {
        $this -> client -> deleteBlob($this -> container, $objectId);
    }

    public function publicUrl(string $objectId): string
    {
        return $this -> client -> getBlobUrl($this -> container, $objectId);
    }
}
